package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/14
 */
@Getter
@Setter
@ApiModel(description = "业务操作信息")
public class BusinessOperationRespVO implements Serializable {
    private static final long serialVersionUID = 2249319558675889317L;

    @ApiModelProperty(value = "业务操作ID")
    private Long id;

    @ApiModelProperty(value = "操作编码")
    private String operationCode;

    @ApiModelProperty(value = "操作名称")
    private String operationName;

    @ApiModelProperty(value = "默认名称")
    private String defaultName;

    @ApiModelProperty(value = "详细描述")
    private String detail;

    /**
     * 取值：{@link com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum}
     */
    @ApiModelProperty(value = "操作类型")
    private String operationType;
    @ApiModelProperty(value = "操作类型名称")
    private String operationTypeName;

    @ApiModelProperty(value = "是否自动过滤权限字段")
    private Boolean fieldPermissionAutoFilter;

    /**
     * 取值：{@link OperationScopeEnum}
     */
    @ApiModelProperty(value = "操作范围")
    private String scope;

    @ApiModelProperty(value = "操作范围")
    private String scopeName;

    /**
     * 取值：{@link OperationStateEnum}
     */
    @ApiModelProperty(value = "操作状态")
    private String state;
    @ApiModelProperty(value = "操作状态名称")
    private String stateName;

    @ApiModelProperty(value = "API操作名称")
    private String apiName;

    @ApiModelProperty(value = "API描述")
    private String apiDescription;

    @ApiModelProperty(value = "API的URL")
    private String apiUrl;

    @ApiModelProperty(value = "API的方法")
    private String apiMethod;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "请求参数")
    private List<OperationParam> requestParams;

    @ApiModelProperty(value = "响应参数")
    private List<OperationParam> responseParams;

    @ApiModelProperty(value = "业务对象字段")
    private List<BusinessObjectParamRespVO> businessParamList;

    @Getter
    @Setter
    @ApiModel(value = "BusinessOperationRespVO_OperationParam")
    public static class OperationParam implements Serializable {
        private static final long serialVersionUID = -1800161466187048863L;

        @ApiModelProperty(value = "字段名称")
        private String fieldName;

        @ApiModelProperty(value = "字段描述")
        private String fieldDescription;

        @ApiModelProperty(value = "字段类型")
        private String fieldType;

        @ApiModelProperty(value = "是否为ApiResult字段")
        private Boolean apiResult;

        @ApiModelProperty(value = "是否必须")
        private Boolean required;

        @ApiModelProperty(value = "是否已过期")
        private Boolean deprecated;

        /**
         * 取值：{@link BusinessObjectParamInEnum}
         */
        @ApiModelProperty(value = "参数位置")
        private String paramIn;

        @ApiModelProperty(value = "是否是单值")
        private Boolean single;

        @ApiModelProperty(value = "是否启用")
        private Boolean enabled;

        @ApiModelProperty(value = "下级参数")
        private List<OperationParam> children;
    }
}
