package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务操作权限参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/20
 */
@Getter
@Setter
@ApiModel(description = "业务操作权限参数")
public class BusinessPermissionParamRespVO implements Serializable {
    private static final long serialVersionUID = -3631679454219291406L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @ApiModelProperty(value = "字段描述")
    private String fieldDescription;

    @ApiModelProperty(value = "字段类型")
    private String fieldType;

    @ApiModelProperty(value = "关联的业务对象")
    private String relatedBusinessObject;

    @ApiModelProperty(value = "关联的业务对象字段")
    private String relatedField;

    private String[] values;

    @ApiModelProperty(value = "账户类型")
    private String userType;

    @ApiModelProperty(value = "支持数据权限")
    private Boolean dataPermissionEnabled;

    @ApiModelProperty(value = "支持字段权限")
    private Boolean fieldPermissionEnabled;
}
