package com.elitescloud.cloudt.system.model.vo.resp.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 外部系统设置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/19
 */
@Data
@ApiModel(description = "外部应用设置")
public class OuterAppSettingRespVO implements Serializable {
    private static final long serialVersionUID = -4714161904827698417L;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 1)
    private String appCode;

    /**
     * 应用名称
     */
    @ApiModelProperty(value = "应用名称", position = 2)
    private String appName;

    /**
     * 图标
     */
    @ApiModelProperty(value = "图标", position = 2)
    private String icon;

    /**
     * 是否展示
     */
    @ApiModelProperty(value = "是否展示", position = 3)
    private Boolean show;

    /**
     * 访问路径
     */
    @ApiModelProperty(value = "访问URL", position = 4)
    private String url;

    /**
     * 生成token的url
     */
    @ApiModelProperty(value = "生成Token的URL", position = 5)
    private String tokenUrl;
}
