package com.elitescloud.cloudt.system.model.vo.resp.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据关系分页信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Getter
@Setter
@ApiModel(description = "数据关系分页信息")
public class DataRelationPagedRespVO implements Serializable {
    private static final long serialVersionUID = -6739083955813889847L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "数据关系编码")
    private String code;

    @ApiModelProperty(value = "数据关系名称")
    private String name;

    @ApiModelProperty(value = "主业务对象编码")
    private String boCode;

    @ApiModelProperty(value = "主业务对象名称")
    private String boName;

    @ApiModelProperty(value = "关联业务对象编码")
    private String refBoCode;

    @ApiModelProperty(value = "关联业务对象名称")
    private String refBoName;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "选择器编码")
    private String dataSelectorCode;

    @ApiModelProperty(value = "选择器名称")
    private String dataSelectorName;

    @ApiModelProperty(value = "是否是组件")
    private Boolean component;

    @ApiModelProperty(value = "组件编码")
    private String componentCode;

    @ApiModelProperty(value = "关联数据接口API")
    private String dataApi;

    @ApiModelProperty(value = "关联数据接口请求方式")
    private String dataApiMethod;
}
