package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 数据权限规则信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/27
 */
@Getter
@Setter
@ApiModel(description = "数据权限规则信息")
public class DataPermissionRespVO implements Serializable {
    private static final long serialVersionUID = -4479897498535240443L;

    @ApiModelProperty(value = "是否使用引用的权限规则", position = 1)
    private Boolean useRef;

    /**
     * 自定义规则列表
     */
    @ApiModelProperty(value = "自定义规则列表", position = 2)
    private List<DataPermissionRuleRespVO> customRuleList;

    /**
     * 字段权限列表
     */
    @ApiModelProperty(value = "字段权限列表", position = 3)
    private List<DataPermissionFieldRespVO> fieldList;

    /**
     * 接口入参列表
     */
    @ApiModelProperty(value = "接口入参列表", position = 4)
    private List<DataPermissionParamRespVO> argList;
}
