package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 数据权限字段.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@ApiModel(description = "数据权限字段")
@Getter
@Setter
public class DataPermissionRuleRespVO implements Serializable {
    private static final long serialVersionUID = 905290874114633794L;

    /**
     * 规则ID
     */
    @ApiModelProperty(value = "规则ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "规则分组", position = 1)
    private String ruleGroup;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 2)
    private String dprRuleName;

    /**
     * 规则字段
     */
    @ApiModelProperty(value = "规则字段", position = 3)
    private String dprRuleField;

    /**
     * 是否引用资源配置
     */
    @ApiModelProperty(value = "是否引用资源配置", position = 4)
    private Boolean refResource;

    /**
     * 引用的业务对象编码
     */
    @ApiModelProperty(value = "引用的业务对象编码", position = 5)
    private String refBusinessObject;
    @ApiModelProperty(value = "引用的业务对象名称", position = 5)
    private String refBusinessObjectName;

    /**
     * 规则条件
     */
    @ApiModelProperty(value = "规则条件", position = 6)
    private DprRuleConditionEnum dprRuleCondition;
    private String dprRuleConditionName;

    /**
     * 取值方式
     */
    @ApiModelProperty(value = "取值方式", position = 7)
    private DprRuleValueTypeEnum dprRuleValueType;
    private String dprRuleValueTypeName;

    /**
     * 数据集类型
     */
    @ApiModelProperty(value = "数据集类型", position = 8)
    private String dataSet;

    /**
     * 规则值
     */
    @ApiModelProperty(value = "规则值", position = 9)
    private String dprRuleValue;
    private String dprRuleValueName;

    /**
     * 规则描述
     */
    @ApiModelProperty(value = "规则描述", position = 10)
    private String dprRuleDeclare;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段1", position = 11)
    private String bs1;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段2", position = 12)
    private String bs2;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段3", position = 13)
    private String bs3;

    public String getDprRuleConditionName() {
        if (dprRuleConditionName == null && dprRuleCondition != null) {
            return dprRuleCondition.getValueDescription();
        }
        return dprRuleConditionName;
    }

    public String getDprRuleValueTypeName() {
        if (dprRuleValueTypeName == null && dprRuleValueType != null) {
            return dprRuleValueType.getValueDescription();
        }
        return dprRuleValueTypeName;
    }
}
