package com.elitescloud.cloudt.system.model.vo.resp.sequence;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 发号规则分页数据.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "发号规则分页数据")
public class SeqRulePageRespVO implements Serializable {
    private static final long serialVersionUID = 3187693094267528754L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码", position = 2)
    private String ruleCode;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 3)
    private String ruleName;

    /**
     * 取号示例
     */
    @ApiModelProperty(value = "取号示例", position = 4)
    private String sampleCode;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 6)
    private LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间", position = 7)
    private LocalDateTime modifyTime;
}
