package com.elitescloud.cloudt.system.model.vo.resp.sys;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/5
 */
@Data
@ApiModel(description = "OpenApi的操作")
public class OpenApiOperationPageRespVO implements Serializable {
    private static final long serialVersionUID = -3583033195939204419L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "接口方法", position = 1)
    private String method;

    @ApiModelProperty(value = "接口地址", position = 2)
    private String url;

    @ApiModelProperty(value = "摘要信息", position = 3)
    private String summary;

    @ApiModelProperty(value = "描述", position = 4)
    private String description;

    @ApiModelProperty(value = "标签列表json字符串", position = 5)
    private String tagsJson;

    @ApiModelProperty(value = "标签列表", position = 5)
    private String[] tags;

    @ApiModelProperty(value = "是否支持业务对象", position = 6)
    private Boolean businessOperation;

    @ApiModelProperty(value = "apiType类型 null|1=内部  2=外部（openfeign）")
    private Integer apiType;

    @ApiModelProperty(value = "操作分组")
    private String operationGroup;

    private String    returnTypeJson;
    private String    parameterTypesJson;
}
