package com.elitescloud.cloudt.system.model.vo.resp.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/28
 */
@Getter
@Setter
@ApiModel(description = "UDC和值的信息")
public class UdcWithValuesPageRespVO implements Serializable {
    private static final long serialVersionUID = 2914854536719086663L;

    @ApiModelProperty(value = "应用编码", position = 1)
    private String appCode;

    @ApiModelProperty(value = "应用名称", position = 1)
    private String appName;

    @ApiModelProperty(value = "UDC的编码", position = 2)
    private String udcCode;

    @ApiModelProperty(value = "UDC的名称", position = 2)
    private String udcName;

    @ApiModelProperty(value = "备注", position = 3)
    private String udcDescribe;

    @ApiModelProperty(value = "值列表", position = 11)
    private List<UdcValue> valueList;

    @Getter
    @Setter
    @ApiModel(value = "UdcWithValuesPageRespVO_UdcValue", description = "UDC值")
    public static class UdcValue implements Serializable {
        private static final long serialVersionUID = -7713553718155469622L;

        @ApiModelProperty(value = "值编码", position = 1)
        private String udcValueCode;

        @ApiModelProperty(value = "显示名称", position = 2)
        private String udcValueName;

        @ApiModelProperty(value = "顺序", position = 3)
        private Integer udcOrder;
    }
}
