package com.elitescloud.cloudt.system.model.vo.resp.user;

import com.elitescloud.cloudt.system.model.vo.resp.org.EmpOrgRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 用户查询结果信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "用户查询结果信息")
public class UserQueryRespVO implements Serializable {
    private static final long serialVersionUID = 7869247301371236819L;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 1)
    private Long id;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 2)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 3)
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 4)
    private String gender;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别名称", position = 4)
    private String genderName;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称", position = 5)
    private String nickName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 6)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 7)
    private String email;

    /**
     * 账号来源
     */
    @ApiModelProperty(value = "账号来源", position = 8)
    private String sourceType;

    /**
     * 账号来源名称
     */
    @ApiModelProperty(value = "账号来源名称", position = 8)
    private String sourceName;

    /**
     * 账号类型
     */
    @ApiModelProperty(value = "账号类型", position = 9)
    private List<String> userTypes;

    /**
     * 账号类型名称
     */
    @ApiModelProperty(value = "账号类型名称", position = 9)
    private List<String> userTypeNames;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 10)
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "账号过期时间" , position = 11)
    private LocalDateTime expiredTime;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "上次登录时间", position = 12)
    private LocalDateTime lastLoginTime;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "创建时间", position = 21)
    private LocalDateTime createTime;

    /**
     * 所属组织
     */
    @ApiModelProperty(value = "所属组织", position = 22)
    private List<EmpOrgRespVO> orgList;
}
