package com.elitescloud.cloudt.system.model.vo.save.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Getter
@Setter
@ApiModel(description = "数据关系保存信息")
public class DataRelationSaveVO implements Serializable {
    private static final long serialVersionUID = 7507299705949602240L;

    @ApiModelProperty(value = "ID，保存时不可为空", position = 1)
    private Long id;

    @NotBlank(message = "数据关系编码为空")
    @ApiModelProperty(value = "数据关系编码", position = 2, required = true)
    private String code;

    @NotBlank(message = "数据关系名称为空")
    @ApiModelProperty(value = "数据关系名称", position = 3, required = true)
    private String name;

    @ApiModelProperty(value = "主业务对象编码", position = 4)
    private String boCode;

    @ApiModelProperty(value = "关联的主业务对象编码", position = 5)
    private String refBoCode;

    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    @ApiModelProperty(value = "说明", position = 7)
    private String remark;

    @Valid
    @ApiModelProperty(value = "分类", position = 11)
    private List<Cat> cats;

    @ApiModelProperty(value = "数据选择器", position = 12)
    private String dataSelectorCode;

    @Getter
    @Setter
    @ApiModel(value = "DataRelationSaveVO_Cat", description = "业务对象数据的分类")
    public static class Cat implements Serializable {
        private static final long serialVersionUID = -5836087492481620372L;

        @NotBlank(message = "分类编码为空")
        @ApiModelProperty(value = "分类编码", position = 1, required = true)
        private String catCode;

        @ApiModelProperty(value = "分类名称", position = 2)
        private String catName;

        @ApiModelProperty(value = "是否启用", position = 3)
        private Boolean enabled;
    }
}
