package com.elitescloud.cloudt.system.model.vo.save.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据权限-行规则.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@Data
@ApiModel(description = "数据权限-行规则保存信息")
public class DataPermissionRuleSaveVO implements Serializable {
    private static final long serialVersionUID = 8243240619082255892L;

    @ApiModelProperty(value = "规则分组", position = 1)
    private String ruleGroup;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 2, required = true)
    private String dprRuleName;

    /**
     * 规则字段
     */
    @ApiModelProperty(value = "规则字段", position = 3, required = true)
    private String dprRuleField;

    @ApiModelProperty(value = "规则字段类型", position = 3, hidden = true)
    private String ruleFieldType;

    /**
     * 是否引用资源配置
     */
    @ApiModelProperty(value = "是否引用资源配置", position = 4)
    private Boolean refResource;

    /**
     * 引用的业务对象编码
     */
    @ApiModelProperty(value = "引用的业务对象编码", position = 5)
    private String refBusinessObject;
    @ApiModelProperty(value = "引用的业务对象编码", position = 5, hidden = true)
    private String refField;

    /**
     * 规则条件
     */
    @ApiModelProperty(value = "规则条件", position = 6)
    private DprRuleConditionEnum dprRuleCondition;

    /**
     * 规则值类型
     */
    @ApiModelProperty(value = "规则值类型", position = 7, required = true)
    @NotNull(message = "规则值类型为空")
    private DprRuleValueTypeEnum dprRuleValueType;

    /**
     * 数据集类型
     */
    @ApiModelProperty(value = "数据集类型", position = 8)
    private String dataSet;

    /**
     * 规则值
     */
    @ApiModelProperty(value = "规则值", position = 9)
    private String dprRuleValue;

    /**
     * 规则值名称
     */
    @ApiModelProperty(value = "规则值名称", position = 10)
    private String dprRuleValueName;

    /**
     * 规则描述
     */
    @ApiModelProperty(value = "规则描述", position = 11)
    private String dprRuleDeclare;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段1", position = 21)
    private String bs1;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段2", position = 22)
    private String bs2;

    /**
     * 特用字段1
     */
    @ApiModelProperty(value = "特用字段3", position = 23)
    private String bs3;
}
