package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 微信公众号接班保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
@Data
public abstract class BaseWechatAppSaveVo {

    /**
     * ID
     */
    @ApiModelProperty(value = "ID，修改时不为空", position = 1)
    private Long id;

    /**
     * 小程序名称
     */
    @ApiModelProperty(value = "小程序名称", position = 2, required = true)
    @NotBlank(message = "小程序名称为空")
    private String name;

    /**
     * AppID
     */
    @ApiModelProperty(value = "AppID", position = 3, required = true)
    @NotBlank(message = "AppID为空")
    private String appId;

    /**
     * AppSecret
     */
    @ApiModelProperty(value = "AppSecret", position = 4, required = true)
    @NotBlank(message = "AppSecret为空")
    private String appSecret;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 11)
    private String remark;
}
