package com.elitescloud.cloudt.system.model.vo.save.extend;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/8 12:01
 */

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 页面字段配置明细;undefined
 * @author : http://www.chiner.pro
 * @date : 2023-9-8
 */
@ApiModel(value = "页面字段配置明细",description = "undefined")
@Getter
@Setter
@Accessors(chain = true)
public class SysPageFieldConfigDtlSaveVO implements Serializable,Cloneable{

    /** 所属应用 */
    @ApiModelProperty(name = "所属应用",notes = "")
    private String appCode ;
    /** 所属应用名称 */
    @ApiModelProperty(name = "所属应用名称",notes = "")
    private String appName ;
    /** 配置名称 */
    @ApiModelProperty(name = "配置名称",notes = "")
    private String configName ;
    /** 配置编码 */
    @ApiModelProperty(name = "配置编码",notes = "")
    private String configCode ;
    /** 字段名称 */
    @ApiModelProperty(name = "字段名称",notes = "")
    private String fieldName ;
    /** 字段编码 */
    @ApiModelProperty(name = "字段编码",notes = "")
    private String fieldCode ;
    /** 是否必填 */
    @ApiModelProperty(name = "是否必填",notes = "")
    private Boolean fieldRequired ;
    /** 字段别名 */
    @ApiModelProperty(name = "字段别名",notes = "")
    private String fieldAlias ;
    /** 行号 */
    @ApiModelProperty(name = "行号",notes = "")
    private Double linenum ;

    @ApiModelProperty(name = "字段类型", notes = "字段的数据类型，这可以用于根据数据类型执行不同的验证或格式化操作")
    private String fieldType;
    @ApiModelProperty(name = "字段类型名称", notes = "字段的数据类型，这可以用于根据数据类型执行不同的验证或格式化操作")
    private String fieldTypeName;
    @ApiModelProperty(name = "字段排序",notes = "字段在页面上的排序顺序")
    private Integer fieldOrder ;
    @ApiModelProperty(name = "是否隐藏",notes = "")
    private Boolean fieldHidden ;
    @ApiModelProperty(name = "是否可编辑",notes = "")
    private Boolean fieldEdit;
    @ApiModelProperty(name = "默认值展示",notes = "")
    private String fieldDefaultValue ;
    @ApiModelProperty(name = "字段宽度",notes = "")
    private String fieldWidth ;
    @ApiModelProperty(name = "字段帮助",notes = "字段的详细描述，以便在页面上提供更多的信息")
    private String fieldDescription;
    @ApiModelProperty(name = "字段样式", notes = "字段的样式属性")
    private String fieldStyle;

}
