package com.elitescloud.cloudt.system.model.vo.save.extend;

import com.elitescloud.cloudt.constant.SheetLimitStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@Data
@ApiModel(description = "模板保存信息")
public class TmplSaveVO implements Serializable {
    private static final long serialVersionUID = -6445709085199293467L;

    @ApiModelProperty(value = "应用编码", required = true, position = 1)
    @NotNull(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty(value = "模板名称", required = true, position = 2)
    @NotBlank(message = "模板名称为空")
    @Size(min = 1, max = 32, message = "模板名称的长度限制为1~32")
    private String name;

    @ApiModelProperty(value = "模板编码，保存后不得修改", required = true, position = 3)
    @NotBlank(message = "模板编码为空")
    @Size(min = 1, max = 32, message = "模板编码的长度限制为1~32")
    private String code;

    @ApiModelProperty(value = "模板文件唯一标识", required = true, position = 4)
    @NotBlank(message = "请先上传模板文件")
    private String fileCode;

    @ApiModelProperty(value = "模板文件名称", position = 4)
    private String fileName;

    @ApiModelProperty(value = "是否是导出模板，默认否", position = 5)
    @NotNull(message = "请选择是否是导出模板")
    private Boolean export;

    @ApiModelProperty(value = "头部所占行数，头部以下都是数据部分", position = 6)
    @NotNull(message = "头部所占行数不能为空")
    @Min(value = 1, message = "头部所占行数最小为1")
    private Integer headRow;

    @ApiModelProperty(value = "数据字段所在行", position = 7)
    @NotNull(message = "数据字段所在行不能为空")
    @Min(value = 1, message = "数据字段所在行最小为1")
    private Integer fieldTypeRow;

    @ApiModelProperty(value = "是否启用，默认是", position = 8)
    private Boolean enabled;

    @ApiModelProperty(value = "导入（或导出）数量限制, -1表示不限制", position = 13)
    @Min(value = -1, message = "数量限制最小为-1")
    private Integer dataLimitPer;

    @ApiModelProperty(value = "并发阀值, -1表示不限制", position = 14)
    @Min(value = -1, message = "并发阀值最小为-1")
    private Integer asyncThreshold;

    @ApiModelProperty(value = "并发数量限制, -1表示不限制", position = 15)
    @Min(value = -1, message = "并发导入数量限制最小为-1")
    private Integer concurrentLimit;

    @ApiModelProperty(value = "导出时sheet页数据量限制，最大100万", position = 21)
    @Min(value = 1, message = "导出时sheet页数据量限制最小为1")
    @Max(value = 1000000, message = "导出时sheet页数据量限制最大为1000000")
    private Integer exportSheetLimit;

    @ApiModelProperty(value = "超出sheet页数量限制后策略（IGNORE-忽略多余数据，NEW_SHEET-写入新sheet，NEW_FILE-写入新文件）", position = 22)
    private SheetLimitStrategy exportSheetStrategy;

    @ApiModelProperty(value = "需要导出的sheet页，从1开始，多个之间以逗号分隔", position = 31)
    private String sheetNos;
}
