package com.elitescloud.cloudt.system.model.vo.save.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 自定义菜单绑定信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/29
 */
@Getter
@Setter
@ApiModel(description = "自定义菜单绑定信息")
public class CustomMenuBoundSaveVO implements Serializable {
    private static final long serialVersionUID = 4476887511839119162L;

    @NotBlank(message = "分组编码不能为空")
    @ApiModelProperty(value = "分组编码", required = true, position = 1)
    private String groupCode;

    @Valid
    @ApiModelProperty(value = "绑定的菜单", position = 2)
    private List<Menu> boundMenus;

    @ApiModelProperty(value = "是否为所有，true-全清全插，false-直接新增")
    private Boolean all;

    @Getter
    @Setter
    @ApiModel(value = "CustomMenuBoundSaveVO_Menu", description = "自定义菜单分组绑定的菜单")
    public static class Menu implements Serializable {
        private static final long serialVersionUID = -3270931328203575677L;

        @ApiModelProperty(value = "菜单编码", required = true, position = 1)
        private String menuCode;

        @ApiModelProperty(value = "自定义菜单名称", position = 1)
        private String customName;
    }
}
