package com.elitescloud.cloudt.system.model.vo.save.message;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author Chris
 * @date 2021-08-21
 */
@Data
@ApiModel("消息模版保存参数")
public class MsgTemplateSaveParam {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty("模版编号")
    @NotBlank(message = "模版编号不能为空")
    private String code;

    @ApiModelProperty(value = "主题")
    private String subject;

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty("是否富文本")
    private Boolean isRichContent;

    @ApiModelProperty(value = "模版内容")
    private String templateText;
}
