package com.elitescloud.cloudt.system.model.vo.save.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 员工的组织信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工的组织信息")
public class EmployeeOrgInfoSaveVO implements Serializable {
    private static final long serialVersionUID = 4774497806183249327L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 1)
    private Long id;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 2, required = true)
    @NotBlank(message = "员工编号为空")
    private String code;

    /**
     * 类型，[UDC]cloudt-system:employeeType
     */
    @ApiModelProperty(value = "类型，[UDC]cloudt-system:employeeType", position = 3)
    private String type;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 4)
    private String duty;

    /**
     * 员工照片
     */
    @ApiModelProperty(value = "员工照片", position = 4)
    private String photo;

    /**
     * 合同起始时间
     */
    @ApiModelProperty(value = "合同起始时间", position = 5)
    private LocalDateTime contractStartTime;

    /**
     * 合同截止时间
     */
    @ApiModelProperty(value = "合同截止时间", position = 6)
    private LocalDateTime contractEndTime;

    /**
     * 入职时间
     */
    @ApiModelProperty(value = "入职时间", position = 7)
    private LocalDateTime joinTime;

    /**
     * 办公电话
     */
    @ApiModelProperty(value = "办公电话", position = 7)
    private String phoneWork;

    /**
     * 工作邮箱
     */
    @ApiModelProperty(value = "工作邮箱", position = 8)
    private String emailWork;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 9)
    private Boolean enabled;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职", position = 9)
    private Boolean served;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 10)
    private Integer sortNo;

    /**
     * 组织信息列表
     */
    @ApiModelProperty(value = "组织信息列表", position = 21)
    @NotEmpty(message = "组织信息为空")
    private List<EmployeeOrgSaveVO> orgList;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 22)
    private String remark;
}
