package com.elitescloud.cloudt.system.model.vo.save.org;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.io.Serializable;

/**
 * 员工保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工保存信息")
public class EmployeeSaveVO extends CustomFieldAbstractVo implements Serializable {
    private static final long serialVersionUID = 5539566416181979075L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID")
    private Long id;

    /**
     * 用户账号信息
     */
    @ApiModelProperty(value = "账号信息", position = 1)
    @Valid
    private UserSaveVO userInfo;

    /**
     * 员工组织信息
     */
    @ApiModelProperty(value = "组织信息", position = 2)
    @Valid
    private EmployeeOrgInfoSaveVO employeeOrgInfo;

    /**
     * 是否没有登录账号
     */
    @ApiModelProperty(value = "是否没有登录账号,默认否", position = 3)
    private Boolean withoutLoginAccount;
}
