package com.elitescloud.cloudt.system.model.vo.save.sequence;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 发号规则.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "发号规则")
public class SeqRuleSaveVO implements Serializable {
    private static final long serialVersionUID = 3187693094267528754L;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称", position = 2, required = true)
    @NotBlank(message = "规则名称为空")
    private String ruleName;

    /**
     * 取号示例
     */
    @ApiModelProperty(value = "取号示例", position = 3)
    private String sampleCode;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 5)
    private String remark;

    /**
     * 规则明细
     */
    @ApiModelProperty(value = "规则明细", position = 6, required = true)
    @NotEmpty(message = "规则明细为空")
    @Valid
    private List<SeqRuleDetailSaveVO> detailsList;
}
