package com.elitescloud.cloudt.system.model.vo.save.sys;

import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Set;

/**
 * 子账号保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
@Getter
@Setter
public abstract class SubUserBaseSaveVO implements Serializable {
    private static final long serialVersionUID = 7484868716818933394L;

    @ApiModelProperty(value = "授权类型，默认是EXTENDS_ALL", position = 2)
    private SubUserPermissionTypeEnum grantType;

    @ApiModelProperty(value = "归属类型，默认是personal", position = 3, hidden = true)
    private BelongType belongType;

    @ApiModelProperty(value = "归属者标识", position = 3, hidden = true)
    private String belongerId;

    @ApiModelProperty(value = "角色编码，授权类型为GRANT_BY_ROLE时必填", position = 21)
    private Set<String> roleCodes;

    @ApiModelProperty(value = "菜单编码，授权类型为GRANT时必填", position = 22)
    private Set<String> menuCodes;
}
