package com.elitescloud.cloudt.system.model.vo.save.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * UDC保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "UDC保存信息")
public class UdcSaveVO implements Serializable {
    private static final long serialVersionUID = 1938481346890404395L;

    /**
     * UDC的ID
     */
    @ApiModelProperty(value = "UDC的ID", position = 1)
    @NotNull(message = "ID不能为空")
    private Long id;

    /**
     * 值列表
     */
    @ApiModelProperty(value = "值列表", position = 3)
    @Valid
    @NotEmpty(message = "值为空")
    private List<UdcValueSaveVO> valueList;
}
