package com.elitescloud.cloudt.system.modules.bi.controller;

import com.elitescloud.boot.constant.AuthenticationClaim;
import com.elitescloud.boot.util.JwtUtil;
import com.elitescloud.cloudt.system.modules.bi.bo.YongHongUserInfoBo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-23 14:28
 */
@Slf4j
@RestController
@RequestMapping(value = "/yongHong")
@Api(tags = "永洪BI接口")
public class YongHongController {

    public static final String SUCCESS = "success";

    @PostMapping("/callBack")
    @ApiOperation(value = "回调用户信息接口")
    @ApiOperationSupport(order = 1)
    public YongHongUserInfoBo sendAsyncOperationLogMqMessage(@RequestParam("token") String token) {
       log.info("永洪BI回调接口：token：{}",token);
        YongHongUserInfoBo result = new YongHongUserInfoBo();
        result.setResult(SUCCESS);

        Map<String,Object> tenantMap = JwtUtil.decode(token);
        log.info("永洪BI回调接口：token：{}",tenantMap);
        result.setUserId(tenantMap.get(AuthenticationClaim.KEY_USERNAME).toString());
//        result.setUserAlias();
//        result.setUserEmail();
//        result.setUserRoles();
//        result.setUserGroups();
//        result.setParam();
        log.info("tenantMap:{}",tenantMap);

        return result;
    }

}
