package com.elitescloud.cloudt.system.modules.message.repository;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepo;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/20
 */
@Repository
public class SysMsgTemplateRepoProc extends BaseRepoProc<SysMsgTemplateDO> {
    private static final QSysMsgTemplateDO QDO = QSysMsgTemplateDO.sysMsgTemplateDO;
    private final TenantMenuRepo tenantMenuRepo;

    public SysMsgTemplateRepoProc(TenantMenuRepo tenantMenuRepo) {
        super(QDO);
        this.tenantMenuRepo = tenantMenuRepo;
    }

    /**
     * 判断模板编号是否存在
     *
     * @param templateCode
     * @return
     */
    public boolean existsTemplateCode(@NotBlank String templateCode) {
        return super.exists(QDO.templateCode, templateCode);
    }

    /**
     * 根据模板编码获取ID
     *
     * @param templateCode
     * @return
     */
    public Long getIdByTemplateCode(@NotBlank String templateCode) {
        return super.getIdByValue(QDO.templateCode, templateCode);
    }
}
