package com.elitescloud.cloudt.system.modules.message.vo.respose;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:51
 */

import com.elitescloud.cloudt.system.modules.message.vo.request.DefaultReceiverVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@ApiModel(description = "模板发送配置")
@Data
public class SysMsgTemplateConfigVO implements Serializable {
    private static final long serialVersionUID = -6932325446949149667L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("模板id")
    private Long templateId;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("发送类型")
    private String sendTypeCode;

    @ApiModelProperty("发送类型开关")
    private Boolean sendTypeSwitch;

    @ApiModelProperty("发送类型")
    private String sendTypeName;

    @ApiModelProperty("主题-暂定udc/暂时无用")
    private String mesSubject;

    @ApiModelProperty("标题")
    private String mesTitle;

    @ApiModelProperty("是否富文本")
    private Boolean mesRichContentSign;

    @ApiModelProperty("内容")
    private String mesText;

    @ApiModelProperty("外部模板id")
    private String externalTemplateId;

    @ApiModelProperty("外部模板签名")
    private String externalSignName;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("业务参数")
    private Map<String, String> businessData;

    @ApiModelProperty("默认接收人")
    private DefaultReceiverVO defaultReceiver;
}
