package com.elitescloud.cloudt.system.modules.orgtree.common;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/1116:14
 */
public class UserUtil {

    private UserUtil() {
    }

    /**
     * 获取当前用户
     *
     * @return 用户dto
     */
    public static SysUserDTO getNowUser() {
        var generalUserDetails = SecurityContextUtil.currentUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            //当前无法取得userId,此处如果userId为null，默认赋值
            return generalUserDetails.getUser();
        }
        return new SysUserDTO();

    }
}
