package com.elitescloud.cloudt.system.modules.orgtree.model.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 组织树版本保存
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/119:28
 */
@Data
public class OrgBuTreeVSaveParam implements Serializable{
    private static final long serialVersionUID = 2093953732778079424L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    private String buTreeName;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    private String buTreeType;

    /**
     * 组织树版本
     */
    @ApiModelProperty(value = "组织树版本")
    private String buTreeVersion;

    /**
     * 版本说明
     */
    @ApiModelProperty(value = "版本说明")
    private String versionInstruction;

    /**
     * 组织树节点
     */
    @ApiModelProperty(value = "组织树节点")
    private List<OrgBuTreeVDSaveParam> treeVDSaveParams;

}
