package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/7
 */
public interface MultiOrgTreeQueryService {

    /**
     * 获取所有组织树
     *
     * @return 组织树列表
     */
    ApiResult<List<IdCodeNameParam>> listOrgTree();

    /**
     * 获取组织树信息
     *
     * @param treeId   树的唯一标识
     * @param tree     是否展示树状
     * @param employee 是否返回员工
     * @param all      是否展示所有
     * @return 树信息
     */
    ApiResult<List<OrgTreeNodeRespVO>> getTree(Long treeId, Boolean tree, Boolean employee, Boolean all);
}
