package com.elitescloud.cloudt.system.provider.export.param;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * udc值导出数据.
 *
 * @author lucan.liu
 * @date 2023/11/16
 */
@Data
public class UdcValueExportBO implements Serializable {
    private static final long serialVersionUID = -785622084105865791L;

    /**
     * 所属应用
     */
    private String appCode;
    /**
     * 所属应用名称
     */
    private String appName;
    /**
     * udc编码
     */
    private String udcCode;
    /**
     * udc名称
     */
    private String udcName;
    /**
     * udc值编码
     */
    private String udcValueCode;
    /**
     * udc值名称
     */
    private String udcValueName;
    /**
     * 排序
     */
    private String udcOrder;
    /**
     * 上级udc编码
     */
    private String parentUdcCode;
    /**
     * 是否内置
     */
    private Boolean allowDefault;
    /**
     * 是否启用
     */
    private Boolean allowStart;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 最后修改时间
     */
    private LocalDateTime modifyTime;
}
