package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.service.SysMqMessageMngService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 删除过期的临时资源.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Slf4j
@Component
public class ClearExpiredMqMessageTask implements Runnable {

    @Autowired
    private SysMqMessageMngService mngService;

    @Override
    public void run() {
        var expiredTime = this.calcExpiredTime();
        mngService.deleteExpiredMessage(expiredTime).computeData();
    }

    private LocalDateTime calcExpiredTime() {
        return LocalDateTime.now().minusMonths(2);
    }
}
