package com.elitescloud.cloudt.system.provider.usersync.jde.convert;

import com.elitescloud.boot.auth.provider.sso2.common.SsoUserInfoConvert;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.provider.usersync.jde.JdeUserSyncProvider;
import com.elitescloud.cloudt.system.service.repo.UserSyncRepoProc;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/31
 */
@Component
public class JdeUserSsoUserConverter implements SsoUserInfoConvert<SysUserDTO> {

    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private UserSyncRepoProc userSyncRepoProc;

    @Override
    public String supportClientId() {
        return systemProperties.getJdeConfig().getClientId();
    }

    @Override
    public SysUserDTO convertUser(SysUserDTO userDTO) {
        var outerUserCode = userSyncRepoProc.getOuterUserCodeByUserId(userDTO.getId(), JdeUserSyncProvider.CODE);
        userDTO.setUsername(outerUserCode);

        return userDTO;
    }
}
