package com.elitescloud.cloudt.system.rest;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.constant.BeanNameConstant;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.common.CacheableServiceClient;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RsaUtil;
import com.elitescloud.boot.web.common.signature.ApiSignature;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.controller.mng.org.EmployeeMngController;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.SysUdcRpcService;
import com.elitescloud.cloudt.system.provider.mq.SystemMqBinding;
import com.elitescloud.cloudt.system.service.OpenApiMngService;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import io.swagger.annotations.*;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.log4j.Log4j2;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.*;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/12
 */
@RestController
@RequestMapping(value = "/sys/test", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "接口测试", tags = "【调试】测试")
@BusinessObject(businessType = BusinessObjectConstant.SYS_TEST)
@Log4j2
@SuppressWarnings({"deprecation", "removal"})
public class SysTestController {
    static {
        InterceptUri.addAllowUri(Set.of("/sys/test/**"));
    }

    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required = false)
    private RedisUtils redisUtils;
    @Autowired(required = false)
    private SystemMqBinding systemMqBinding;

    @Autowired
    private SysUdcRpcService udcRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private DiscoveryClient discoveryClient;
    //    @Autowired(required = false)
//    private MessageQueueTemplate messageQueueTemplate;
    @Autowired
    private OrgRepoProc orgRepoProc;

    @ApiOperation("测试接口")
    @ApiOperationSupport(order = 2)
    @GetMapping(value = "/hello")
    public ApiResult<String> hello() {
        return ApiResult.ok("Hello");
    }

    /**
     * 获取当前用户信息
     *
     * @return
     * @throws JsonProcessingException
     */
    @ApiOperation("获取当前用户信息")
    @ApiOperationSupport(order = 3)
    @GetMapping(value = "/users/current")
    public ApiResult<String> getCurrentUser(String req) throws JsonProcessingException {
        var obj = SecurityContextUtil.currentUser();
        if (StringUtils.hasText(req)) {
            throw new BusinessException("异常");
        }
        var res = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        return ApiResult.ok(res);
    }

    @ApiOperation("用户信息获取（模拟登陆）")
    @ApiOperationSupport(order = 10)
    @GetMapping(value = "/user/get")
    public String getUserInfo(String username) throws JsonProcessingException {
        log.info("查询用户信息");
        UserTransferHelper.getInstance(SpringContextHolder.getBean(AuthorizationSdkProperties.class).getAuthServer()).validatePwd(null, null, "123456");
        var obj = sysUserService.getUserByUsername(username);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    @ApiOperation("通过ID取得用户明细（新）")
    @ApiOperationSupport(order = 21)
    @GetMapping("/users/details/{id}")
    public ApiResult<SysUserDetailsVO> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok(sysUserService.findDetailsById(id));
    }

    @ApiOperation("模糊查询redis keys")
    @ApiOperationSupport(order = 30)
    @GetMapping(value = "/redis/keys")
    public ApiResult<Set<String>> scanRedisKeys(String prefix, String del) {
        String key = prefix + "*";
        Set<String> keys = redisUtils.getRedisTemplate().keys(key);
        log.info("数量：{}", keys.size());

        List<String> keys1 = redisUtils.scan(key);
        if ("true".equals(del)) {
            if (CollUtil.isNotEmpty(keys)) {
                for (String s : keys) {
                    redisUtils.del(s);
                }
            }
            if (CollUtil.isNotEmpty(keys1)) {
                for (String s : keys1) {
                    redisUtils.del(s);
                }
            }
        }

        return ApiResult.ok(new HashSet<>(keys1));
    }

    /**
     * 测试redis值操作
     *
     * @param key   key
     * @param value value，空时取值
     * @return value
     */

    @ApiOperation("测试redis值操作")
    @ApiOperationSupport(order = 31)
    @GetMapping(value = "/redis/get")
    @BusinessObjectOperation(logEnabled = true, operationType = OperationTypeEnum.ELSE, operationDescription = "测试redis值操作")
    public ApiResult<String> testRedisValue(String key, String value) {
        if (!StringUtils.hasText(key)) {
            return ApiResult.fail("key为空");
        }

        if (StringUtils.hasText(value)) {
            redisUtils.set(key, value);
            return ApiResult.ok("设置值：" + value);
        }

        value = (String) redisUtils.get(key);
        return ApiResult.ok("取得值：" + value);
    }

    @ApiOperation("MQ发送消息")
    @ApiOperationSupport(order = 40)
    @GetMapping(value = "/mq/send")
    public ApiResult<String> testSendMq() {
        Message<String> message = MessageBuilder.withPayload("hello")
                .setHeader("un", "wangs")
                .build();
        systemMqBinding.systemOutput().send(message);

        return ApiResult.ok("success");
    }

    @ApiOperation("CloudtMQ")
    @ApiOperationSupport(order = 41)
    @GetMapping(value = "/mq/cloudt")
    public ApiResult<String> cloudtMq(@RequestParam(name = "channel", required = false) String channel,
                                      @RequestParam(name = "pub", required = false, defaultValue = "false") Boolean pub) throws Exception {
        if (CharSequenceUtil.isBlank(channel)) {
            channel = "mq_wangs";
        }

        FileInfoVO fileInfoVO = new FileInfoVO();
        fileInfoVO.setFileCode(DatetimeUtil.currentTimeLong());
        fileInfoVO.setUploadTime(LocalDateTime.now());
        if (Boolean.TRUE.equals(pub)) {
            SpringContextHolder.getBean(MessageQueueTemplate.class).publishMessage(channel, fileInfoVO);
        } else {
            SpringContextHolder.getBean(MessageQueueTemplate.class).sendMessage(channel, fileInfoVO);
        }

        return ApiResult.ok(fileInfoVO.getFileCode());
    }

    @Autowired
    private TestOpenFeign openFeign;

    @ApiOperation("测试获取服务器信息")
    @ApiOperationSupport(order = 50)
    @GetMapping(value = "/server/info")
    @BusinessObjectOperation(logEnabled = true, operationType = OperationTypeEnum.ELSE, operationDescription = "测试获取服务器信息",
            allowRepeatRequest = false, businessParamValueKey = "#p1")
    public ApiResult<Map<String, Object>> testGetServerInfo(HttpServletRequest request, String sn) {
        Map<String, Object> result = new HashMap<>(8);
        result.put("内核数", Runtime.getRuntime().availableProcessors());
        result.put("请求路径", request.getRequestURL());
        result.put("客户端IP", HttpServletUtil.currentClientIp());
        result.put("remoteAddr", request.getRemoteAddr());
        result.put("header-origin", request.getHeader(HttpHeaders.ORIGIN));
        result.put("header-host", request.getHeader(HttpHeaders.HOST));
        result.put("header-referer", request.getHeader(HttpHeaders.REFERER));
        result.put("解析得域名", HttpServletUtil.obtainDomain(request));

        log.info("获取客户端IP：{}", getClientIP(request));
        log.info("执行者：{}", ExecutorContextHolder.get());

        tenantDataIsolateProvider.byTenantDirectly(() -> {
            log.info("租户：{}", SpringContextHolder.getBean(TenantClientProvider.class).getSessionTenant());

            CompletableFuture.runAsync(() -> {
                try {
                    TimeUnit.SECONDS.sleep(5);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                log.info("异步获取客户端IP：{}", getClientIP(request));
                log.info("异步执行者：{}", ExecutorContextHolder.get());
                log.info("用户：{}", SecurityContextUtil.currentUser());
                log.info("租户：{}", SpringContextHolder.getBean(TenantClientProvider.class).getSessionTenant());
            }, taskExecutor);

            return null;
        }, "1009");

        return ApiResult.ok(result);
    }

    @ApiOperation("测试获取OpenAPI")
    @ApiOperationSupport(order = 51)
    @GetMapping("/openApi/get")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DOWNLOAD, operationDescription = "返回平台的OpenAPI JSON")
    public String getJson(@RequestParam(name = "single", required = false, defaultValue = "false") Boolean single) throws IOException {
        OpenAPI openAPI = null;
        if (Boolean.TRUE.equals(single)) {
            openAPI = SpringContextHolder.getBean(OpenApiMngService.class).testAnalyzeController(EmployeeMngController.class).getData();
        }
        openAPI = SpringContextHolder.getBean(OpenApiMngService.class).testAnalyzeController(null).getData();
        return Json.pretty(openAPI);
    }

    private static String getClientIP(HttpServletRequest request, String... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(new String[][]{headers, otherHeaderNames});
        }

        return getClientIPByHeader(request, headers);
    }

    private static String getClientIPByHeader(HttpServletRequest request, String... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (!NetUtil.isUnknown(ip)) {
                log.info("尝试获取请求头：{}, {}", header, ip);
                return NetUtil.getMultistageReverseProxyIp(ip);
            }
        }

        ip = request.getRemoteAddr();
        log.info("尝试获取RemoteAddr:{}", ip);
        return NetUtil.getMultistageReverseProxyIp(ip);
    }

    @ApiOperation("获取所有请求头")
    @ApiOperationSupport(order = 51)
    @GetMapping(value = "/request/headers")
    public ApiResult<MultiValueMap<String, String>> testGetHeaders(HttpServletRequest request) {
        var headers = HttpServletUtil.getHeaders(request);
        log.info("请求头：{}", headers);

        return ApiResult.ok(headers);
    }

    @ApiOperation("获取MDC值")
    @ApiOperationSupport(order = 52)
    @GetMapping(value = "/mdc/value")
    public ApiResult<String> testMdc(@RequestParam(name = "name", required = false) String name) {
//        var traceId = Span.current().getSpanContext().getTraceId();
//        log.info("traceId:{}", traceId);
        if (CharSequenceUtil.isBlank(name)) {
            return ApiResult.ok(JSONUtil.toJsonString(MDC.getCopyOfContextMap()));
        }

        taskExecutor.execute(() -> {
            log.info("异步线程：{}", JSONUtil.toJsonString(MDC.getCopyOfContextMap()));
        });

        var value = MDC.get(name);
        return ApiResult.ok(value);
    }

    @ApiOperation("上传资源文件")
    @ApiOperationSupport(order = 53)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "file", value = "文件"),
            @ApiImplicitParam(name = "businessType", value = "业务类型"),
    })
    @PostMapping(value = "/res/upload")
    public ApiResult<FileInfoVO> testUploadResource(@RequestParam(name = "file") MultipartFile file,
                                                    @RequestParam(name = "businessType") String businessType) {
        return SpringContextHolder.getBean(ResourceByteMngService.class).saveResource(file, businessType);
    }

    @ApiOperation("查询UDC信息")
    @ApiOperationSupport(order = 60)
    @GetMapping(value = "/udc/get")
    public ApiResult<SysUdcDTO> getUdc(String appCode, String udcCode) {
        return udcRpcService.get(appCode, udcCode);
    }

    @ApiOperation("查询UDC列表")
    @ApiOperationSupport(order = 61)
    @PostMapping(value = "/udc/list")
    @BusinessObjectOperation(logEnabled = true, operationType = OperationTypeEnum.ELSE, operationDescription = "查询UDC列表", allowRepeatRequest = false)
    public ApiResult<List<SysUdcDTO>> listUdc(String appCode, @RequestBody Set<String> udcCodes) {
        return udcRpcService.listByUdcCode(appCode, udcCodes);
    }

    @ApiOperation("获取UDC信息（缓存）")
    @ApiOperationSupport(order = 62)
    @GetMapping(value = "/udc/get/cache")
    public ApiResult<SysUdcDTO> getUdcCache(String appCode, String udcCode) {

        var udcDto = udcProvider.getByUdcCode(appCode, udcCode);
        return ApiResult.ok(udcDto);
    }

    @ApiOperation("生成ID")
    @ApiOperationSupport(order = 63)
    @GetMapping(value = "/id/next")
    public ApiResult<Serializable> idNext() {
        return ApiResult.ok(IdGenerator.generate());
    }

    @ApiOperation("发号器")
    @ApiOperationSupport(order = 64)
    @GetMapping(value = "/seq/next")
    public ApiResult<List<String>> seq(String appCode, String ruleCode, Integer num) {
        // 本机
//        var value = SpringContextHolder.getBean(SeqNumFactory.class).generateCode(appCode, ruleCode, null, ObjectUtil.defaultIfNull(num, 1));
        // rpc
        var value = seqNumProvider.generateCode(appCode, ruleCode, null, ObjectUtil.defaultIfNull(num, 1));
        return ApiResult.ok(value);
    }

    @ApiOperation("发送站内信")
    @ApiOperationSupport(order = 65)
    @PostMapping(value = "/messenger/site")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "发送站内信",
            allowRepeatRequest = false, businessParamValueKey = "#p0.subject")
    public ApiResult<String> testSendSiteMsg(@RequestBody MessageSiteVO siteVO) {
        var msgId = Messenger.siteMessage()
                .setSubject(CharSequenceUtil.blankToDefault(siteVO.getSubject(), "未提供标题"))
                .setContent(CharSequenceUtil.blankToDefault(siteVO.getContent(), "未提供内容"))
                .setReceiverList(List.of(new MessageAccountVO(CharSequenceUtil.blankToDefault(siteVO.getUsername(), "admin"))))
                .setBusinessType(CharSequenceUtil.blankToDefault(siteVO.getBusinessType(), "approve"))
                .setBusinessParams(siteVO.getBusinessParams())
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送邮件")
    @ApiOperationSupport(order = 66)
    @ApiImplicitParam(name = "emailAddress", value = "邮箱地址", required = true)
    @BusinessObjectOperation(logEnabled = true, operationType = OperationTypeEnum.ELSE, operationDescription = "发送邮件", allowRepeatRequest = false)
    @PostMapping(value = "/messenger/email")
    public ApiResult<String> testSendEmailMsg(@RequestParam(name = "emailAddress") String emailAddress) {
        Assert.hasText(emailAddress, "邮件地址为空");
        var msgId = Messenger.email()
                .setSubject("测试邮件")
                .setContent("邮件内容")
                .setReceiverList(List.of(new MessageAccountVO(emailAddress, "wangs")))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送html邮件")
    @ApiOperationSupport(order = 66)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "emailAddress", value = "邮箱地址", required = true),
            @ApiImplicitParam(name = "fileUrl", value = "图片的访问路径", required = true),
    })
    @BusinessObjectOperation(logEnabled = true, operationType = OperationTypeEnum.ELSE, operationDescription = "发送邮件", allowRepeatRequest = false)
    @PostMapping(value = "/messenger/emailHtml")
    public ApiResult<String> testSendEmailMsg(@RequestParam(name = "emailAddress") String emailAddress,
                                              @RequestParam(name = "fileUrl") String fileUrl) {
        Assert.hasText(emailAddress, "邮件地址为空");
        var msgId = Messenger.richTextEmail()
                .setSubject("测试邮件")
                .setContent("邮件内容，<img src='" + fileUrl + "' />")
                .setReceiverList(List.of(new MessageAccountVO(emailAddress, "wangs")))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送短信")
    @ApiOperationSupport(order = 67)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "mobile", value = "手机号", required = true),
            @ApiImplicitParam(name = "templateCode", value = "模板编码"),
            @ApiImplicitParam(name = "signName", value = "签名"),
    })
    @PostMapping(value = "/messenger/sms")
    public ApiResult<String> testSendSmsMsg(@RequestParam(name = "mobile") String mobile,
                                            @RequestParam(name = "templateCode", required = false) String templateCode,
                                            @RequestParam(name = "signName", required = false) String signName) {
        Assert.hasText(mobile, "手机号为空");
        var msgId = Messenger.templateSms()
                .setSubject("标题")
                .setContent("内容")
                .setReceiverList(List.of(new MessageAccountVO(mobile)))
                .setTemplateCode(CharSequenceUtil.blankToDefault(templateCode, "SMS_269440639"))
                .setTemplateParam(Map.of("code", "147852"))
                .setSignName(signName)
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送App消息")
    @ApiOperationSupport(order = 68)
    @ApiImplicitParam(name = "username", value = "用户名", required = true)
    @GetMapping(value = "/messenger/app")
    public ApiResult<String> testSendAppMsg(@RequestParam(name = "username") String username) {
        Assert.hasText(username, "账号为空");
        var msgId = Messenger.appMessage()
                .setSubject("你有新的审批提醒")
                .setContent("这是待审批的内容...")
                .setReceiverList(List.of(new MessageAccountVO(username)))
                .setBusinessType("appr_order")
                .setBusinessParams(Map.of("code", "147852"))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("缓存中获取设置项")
    @ApiOperationSupport(order = 69)
    @ApiImplicitParam(name = "code", value = "缓存编码")
    @GetMapping(value = "/cache/setting")
    public ApiResult<Object> testGetSettingCache(@RequestParam(name = "code", required = false) String code) {
        var rpcService = SpringContextHolder.getBean(SysCacheSettingRpcService.class);
        if (StringUtils.hasText(code)) {
            return ApiResult.ok(rpcService.oneByNo(code));
        }
        return ApiResult.ok(rpcService.all());
    }

    @ApiOperation("清空缓存项")
    @ApiOperationSupport(order = 70)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "appCode", value = "应用编码", required = true),
            @ApiImplicitParam(name = "code", value = "缓存服务标识"),
    })
    @GetMapping(value = "/cache/clear")
    public ApiResult<Boolean> testClearCache(@RequestParam(name = "appCode") String appCode,
                                             @RequestParam(name = "code", required = false) String code) {
        var rpcService = DynamicClientHelper.getClient(appCode, CacheableServiceClient.class, CacheableServiceClient.URI);
        rpcService.clearAll(code);
        return ApiResult.ok(true);
    }

    @ApiOperation("获取注册的服务")
    @ApiOperationSupport(order = 71)
    @GetMapping(value = "/service/list")
    public ApiResult<String> testGetServices(String instanceName) {
        log.info("服务列表：{}", String.join(",", discoveryClient.getServices()));
        if (StringUtils.hasText(instanceName)) {
            for (ServiceInstance instance : discoveryClient.getInstances(instanceName)) {
                log.info("instanceId：{}, serviceId：{}, schema: {} Host：{}, Port：{}, Uri：{}, secure: {} metadata：{}",
                        instance.getInstanceId(), instance.getServiceId(), instance.getScheme(), instance.getHost(),
                        instance.getPort(), instance.getUri(), instance.isSecure(), instance.getMetadata());
            }
        }
        return ApiResult.ok("success");
    }

    @ApiOperation("解析导入的UDC")
    @ApiOperationSupport(order = 81)
    @PostMapping(value = "/udc/import")
    public ApiResult<String> testImportUdc(@RequestParam("file") MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return ApiResult.fail("上传文件为空");
        }

        var sqlList = this.generateUdcSql(file);
        return ApiResult.ok(String.join("", sqlList));
    }

    @ApiOperation("测试接口自动验签")
    @ApiOperationSupport(order = 82)
    @PostMapping(value = "/sign")
    @ApiSignature(model = SignatureModel.VERIFY_SIGN)
    public ApiResult<SysSettingVO> testSignature(@RequestBody SysSettingVO sysSettingVO, HttpServletRequest request) {
        var headerName = SpringContextHolder.getBean(WebProperties.class).getApiSign().getSignatureParamName();
        System.out.println(request.getHeader(headerName));

        return ApiResult.ok(sysSettingVO);
    }

    @Autowired(required = false)
    @Qualifier(BeanNameConstant.REST_TEMPLATE_SIGNABLE)
    private RestTemplate restTemplate;

    @ApiOperation("测试RestTemplate签名")
    @ApiOperationSupport(order = 83)
    @GetMapping(value = "/sign/restTemplate")
    public ApiResult<String> testSignature() {
        Map<String, Object> body = new HashMap<>();
        body.put("settingNo", DatetimeUtil.currentTimeLong());
        var result = restTemplate.postForEntity("http://127.0.0.1:9010/sys/test/sign", body, String.class);

        return ApiResult.ok(result.getBody());
    }

    @ApiOperation("生成RSA密钥对")
    @ApiOperationSupport(order = 84)
    @GetMapping(value = "/rsa/generate")
    public ApiResult<Map<String, String>> testGenerateRsa() {
        var keypair = RsaUtil.generateKeyPair();

        Map<String, String> result = new HashMap<>();
        result.put("publicKey", RsaUtil.convertKey2Str(keypair.getPublic()));
        result.put("privateKey", RsaUtil.convertKey2Str(keypair.getPrivate()));

        return ApiResult.ok(result);
    }

    @ApiOperation("测试RSA签名")
    @ApiOperationSupport(order = 85)
    @PostMapping(value = "/rsa/sign/test")
    public ApiResult<String> testSignature(@RequestBody SignVO signVO) {
        String result = RsaUtil.sign(RsaUtil.convert2PrivateKey(signVO.getPrivateKey()), signVO.getSignatureAlgorithm(), signVO.getPlainText());

        return ApiResult.ok(result);
    }

    @ApiOperation("测试RSA验证签名")
    @ApiOperationSupport(order = 85)
    @PostMapping(value = "/rsa/sign/testVerify")
    public ApiResult<Boolean> testVerifySignature(@RequestBody VerifySignVO signVO) {
        var result = RsaUtil.verifySign(RsaUtil.convert2PublicKey(signVO.getPublicKey()), signVO.getSignatureAlgorithm(), signVO.getPlainText(), signVO.getSignature());

        return ApiResult.ok(result);
    }

    @ApiOperation(value = "显示图片", hidden = true)
    @ApiOperationSupport(order = 99)
    @Ignore
    @ApiImplicitParam(name = "fileCode", value = "文件唯一标识", required = true)
    @GetMapping({"/img/show"})
    public HttpEntity<Resource> show(@RequestParam(name = "fileCode") String fileCode, HttpServletResponse response) {
        log.info("请求：{}", fileCode);
        HttpEntity<Resource> httpEntity = null;
        try {
            httpEntity = SpringContextHolder.getBean(FileService.class).preview(fileCode, null);
        } catch (Exception e) {
            log.error("预览图片异常：", e);
            return ResponseEntity.badRequest().build();
        }

        if (httpEntity.getHeaders().getContentType() == null) {
            response.setContentType("image/jpeg");
        }

        response.setHeader("Cache-Control", CacheControl.noStore().getHeaderValue());
        return httpEntity;
    }

    private List<String> generateUdcSql(MultipartFile file) throws Exception {
        List<Map<String, Object>> dataList = (List<Map<String, Object>>) ExcelImportUtil.instance(file.getInputStream())
                .headRow(1)
                .sheetNo(Set.of(1))
                .dataType(null, 1)
                .readAllSync();
        log.info("数据量：{}", dataList.size());

        List<Map<String, Object>> udcParamList = new ArrayList<>();
        List<Map<String, Object>> udcValueParamList = new ArrayList<>();

        Set<String> existsUdc = new HashSet<>();
        Set<String> existsUdcValue = new HashSet<>();
        int i = 0;
        long id = System.currentTimeMillis();
        for (Map<String, Object> data : dataList) {
            i++;
            Map<String, Object> udcParams = new HashMap<>();
            Map<String, Object> udcValueParams = new HashMap<>();

            var appCode = data.get("app_code");
            var udcCode = data.get("udc_code");
            var udcValueCode = data.get("udc_value_code");

            if (!existsUdc.contains(appCode + ":" + udcCode)) {
                udcParams.put("id", id + i);
                udcParams.put("tenant_id", -1);

                udcParams.put("app_code", appCode);
                udcParams.put("udc_code", udcCode);
                udcParams.put("udc_name", data.get("udc_name"));
                udcParams.put("udc_describe", data.get("udc_describe"));

                existsUdc.add(appCode + ":" + udcCode);
                udcParamList.add(udcParams);
            }

            if (existsUdcValue.contains(appCode + ":" + udcCode + ":" + udcValueCode)) {
                System.out.println("已存在：" + appCode + ":" + udcCode + ":" + udcValueCode);
                continue;
            }
            existsUdcValue.add(appCode + ":" + udcCode + ":" + udcValueCode);

            udcValueParams.put("id", id + i);
            udcValueParams.put("tenant_id", -1);
            udcValueParams.put("app_code", appCode);
            udcValueParams.put("udc_code", udcCode);
            udcValueParams.put("udc_value_code", udcValueCode);
            udcValueParams.put("udc_value_name", data.get("udc_value_name"));
            udcValueParams.put("udc_order", data.get("udc_order"));
            udcValueParams.put("udc_value_describe", data.get("udc_value_describe"));
            udcValueParamList.add(udcValueParams);
        }

        List<String> sqlList = new ArrayList<>();
        for (Map<String, Object> udc : udcParamList) {
            udc.put("allow_update", 1);
            udc.put("allow_add_value", 0);

            sqlList.add(this.convertSql("sys_platform_udc", udc));
        }
        for (Map<String, Object> udc : udcValueParamList) {
            udc.put("allow_start", 1);
            udc.put("allow_default", 1);

            sqlList.add(this.convertSql("sys_platform_udc_value", udc));
        }

        return sqlList;
    }

    private String convertSql(String tableName, Map<String, Object> params) {
        List<String> fieldList = new ArrayList<>();
        List<String> valueList = new ArrayList<>();

        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) {
                continue;
            }

            if (entry.getValue() instanceof String) {
                if (CharSequenceUtil.isBlank((String) entry.getValue())) {
                    continue;
                }

                valueList.add("'" + entry.getValue() + "'");
            } else {
                valueList.add(entry.getValue().toString());
            }
            fieldList.add(entry.getKey());
        }

        return "insert into " + tableName + "(" + String.join(", ", fieldList) + ") values "
                + "(" + String.join(", ", valueList) + ");";
    }

    @Getter
    @Setter
    @ApiModel(description = "站内信信息")
    public static class MessageSiteVO implements Serializable {
        private static final long serialVersionUID = -1485869990419072189L;

        @ApiModelProperty(value = "标题", position = 1, required = true)
        private String subject;

        @ApiModelProperty(value = "内容", position = 2, required = true)
        private String content;

        @ApiModelProperty(value = "接收人账号", position = 3, required = true)
        private String username;

        @ApiModelProperty(value = "业务类型", position = 4, required = true)
        private String businessType;

        @ApiModelProperty(value = "业务扩展参数", position = 5)
        private Map<String, String> businessParams;
    }

    @Getter
    @Setter
    public static class SignVO implements Serializable {
        private static final long serialVersionUID = -6909523282514635746L;

        @ApiModelProperty(value = "私钥")
        private String privateKey;

        @ApiModelProperty(value = "签名算法")
        private String signatureAlgorithm;

        @ApiModelProperty(value = "明文内容")
        private String plainText;
    }

    @Getter
    @Setter
    public static class VerifySignVO implements Serializable {
        private static final long serialVersionUID = -6909523282514635746L;

        @ApiModelProperty(value = "公钥")
        private String publicKey;

        @ApiModelProperty(value = "签名算法")
        private String signatureAlgorithm;

        @ApiModelProperty(value = "明文内容")
        private String plainText;

        @ApiModelProperty(value = "签名")
        private String signature;
    }
}
