package com.elitescloud.cloudt.system.rest;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.param.SysAccountUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysPasswordUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysUserAvatarUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysVerifyCodeParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/16
 */
@Api(tags = {"用户信息管理（适用于个人）"})
@ApiSupport(author = "Kaiser（wang shao）")
@RestController
@RequestMapping(value = "/sys/user/self", produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUserSelfController {
    static {
        // 加入白名单
        InterceptUri.addAllowUri(Set.of("/sys/user/self/updatePwd/verifyCode", "/sys/user/self/updateAccount/verifyCode",
                "/sys/user/self/updateAccount/verifyOldAccount"));
    }

    private UserMngService userMngService;

    @ApiOperation(value = "更新头像")
    @ApiOperationSupport(order = 1)
    @PutMapping(value = "/avatar")
    public ApiResult<Long> updateAvatar(@RequestBody @Valid SysUserAvatarUpdateParam updateParam) {
        return userMngService.updateAvatar(updateParam);
    }

    @ApiOperation(value = "【修改密码】发送验证码")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/updatePwd/verifyCode")
    public ApiResult<String> sendVerifyCodeForUpdatePwd(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return userMngService.sendVerifyCodeForUpdatePassword(verifyCodeParam);
    }

    @ApiOperation(value = "【修改密码】根据验证码修改密码")
    @ApiOperationSupport(order = 3)
    @PutMapping(value = "/updatePwd/verifyCode")
    public ApiResult<Long> updatePwd(@RequestBody @Valid SysPasswordUpdateParam updateParam) {
        return userMngService.updatePasswordByVerifyCode(updateParam);
    }

    @ApiOperation(value = "【修改账号】发送验证码")
    @ApiOperationSupport(order = 4)
    @PostMapping(value = "/updateAccount/verifyCode")
    public ApiResult<String> sendVerifyCodeForUpdateAccount(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return userMngService.sendVerifyCodeForUpdateAccount(verifyCodeParam);
    }

    @ApiOperation(value = "【修改账号】校验老的账号")
    @ApiOperationSupport(order = 5)
    @PostMapping(value = "/updateAccount/verifyOldAccount")
    public ApiResult<String> verifyOldAccount(@RequestBody @Valid SysVerifyCodeParam verifyCodeParam) {
        return userMngService.verifyCodeForUpdateAccount(verifyCodeParam);
    }

    @ApiOperation(value = "【修改账号】根据验证码修改账号")
    @ApiOperationSupport(order = 6)
    @PutMapping(value = "/updateAccount/verifyCode")
    public ApiResult<Long> updateAccount(@RequestBody @Valid SysAccountUpdateParam updateParam) {
        return userMngService.updateAccountByVerifyCode(updateParam);
    }

    @Autowired
    public void setUserMngService(UserMngService userMngService) {
        this.userMngService = userMngService;
    }
}
