package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.service.AuthUserService;
import com.elitescloud.cloudt.system.service.PermissionMngService;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@RestController
@RequestMapping(value = SysUserPermissionRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUserPermissionRpcServiceImpl implements SysUserPermissionRpcService {

    private PermissionMngService permissionMngService;
    private PermissionQueryService permissionQueryService;
    private AuthUserService authUserService;

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRoles(String tenantCode) {
        return permissionQueryService.listAllRoles(tenantCode);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRolesByTenantOrg(String tenantOrgCode) {
        return permissionQueryService.listAllRolesByTenantOrg(tenantOrgCode);
    }

    @Override
    public ApiResult<Long> saveUserRoles(Long userId, List<Long> roleIds) {
        return permissionMngService.saveUserRoles(userId, roleIds);
    }

    @Override
    public ApiResult<List<Long>> saveUserRoles(List<UserRoleSaveDTO> saveDTOList) {
        return permissionMngService.saveUserRoles(saveDTOList);
    }

    @Override
    public ApiResult<Set<Long>> getUserIdByRoleCode(String roleCode) {
        return permissionQueryService.getUserIdByRoleCode(roleCode);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> listUserByRole(String roleCode) {
        return permissionQueryService.listUserByRole(roleCode);
    }

    @Override
    public ApiResult<OAuthToken> authByUserId(AuthUserIdQueryDTO queryDTO) {
        if (authUserService == null) {
            return ApiResult.fail("暂不支持认证");
        }
        return authUserService.authByUserId(queryDTO.getUserIdCypher());
    }

    @Override
    public ApiResult<String> getTokenByTicket(String ticket) {
        if (authUserService == null) {
            return ApiResult.fail("暂不支持ticket换token");
        }
        return authUserService.ticket2Token(ticket);
    }

    @Autowired
    public void setPermissionMngService(PermissionMngService permissionMngService) {
        this.permissionMngService = permissionMngService;
    }

    @Autowired
    public void setPermissionQueryService(PermissionQueryService permissionQueryService) {
        this.permissionQueryService = permissionQueryService;
    }

    @Autowired(required = false)
    public void setAuthUserService(AuthUserService authUserService) {
        this.authUserService = authUserService;
    }
}
