package com.elitescloud.cloudt.system.rpc.dpr.strategy;

import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:28
 */
@Service
public class DprSysInternallyStrategyFactory {

    private final Map<DprSysInternallyEnum, IDprSysInternallyStrategy> strategies = new HashMap<>();

    @Autowired
    public DprSysInternallyStrategyFactory(List<IDprSysInternallyStrategy> strategyList) {
        strategyList.forEach(strategy -> strategies.put(strategy.getType(), strategy));
    }

    public IDprSysInternallyStrategy getStrategy(DprSysInternallyEnum type) {
        return strategies.getOrDefault(type, null);
    }
//
//    static {
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE, new DprSysInternallyEmployee());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB, new DprSysInternallyEmployeeLocalSub());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN, new DprSysInternallyEmployeeSalesman());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_SUB, new DprSysInternallyEmployeeSub());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_ORG, new DprSysInternallyOrg());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_ORG_LOCAL_SUB, new DprSysInternallyOrgLocalSub());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_ORG_SUB, new DprSysInternallyOrgSub());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_OU, new DprSysInternallyOu());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_USER_LOCAL_SUB, new DprSysInternallyUserLocalSub());
//        strategies.put(DprSysInternallyEnum.DPR_SYS_INTERNALLY_USER_SUB, new DprSysInternallyUserSub());
//        // ...其他策略初始化...
//    }
//
//    public static IDprSysInternallyStrategy getStrategy(DprSysInternallyEnum type) {
//        return strategies.getOrDefault(type,null );
//    }
}

