package com.elitescloud.cloudt.system.rpc.dpr.strategy;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.RoleAppApiDataPermissionRpcServiceUtil;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import org.springframework.util.StringUtils;

import java.util.Collection;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:19
 */
public interface IDprSysInternallyStrategy {

    DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo,
                                                   SysDprRoleApiDataRuleListQueryDTO ruleDTO);
    DprSysInternallyEnum getType();
    default String normalizeValue(Collection<?> values) {
        return RoleAppApiDataPermissionRpcServiceUtil.normalizeRuleValue(values);
    }

    default boolean isIdField(String fieldName) {
        return fieldName != null && (fieldName.contains("id") || fieldName.contains("Id"));
    }

    default boolean isCodeField(String fieldName) {
        return fieldName != null && (fieldName.contains("code") || fieldName.contains("Code"));
    }
}
