package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Slf4j
@Component
public class DprSysInternallyDynamic implements IDprSysInternallyStrategy {
    public static final String PREFIX = DprSysInternallyEnum.DPR_SYS_INTERNALLY_DYNAMIC.getUdcVO().getUdcCode() + "::userType::";

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        var userType = ruleDTO.getDprRuleValue().substring(PREFIX.length());

        Long value = null;
        for (SysUserType sysUserType : userInfo.getUser().getUserTypeList()) {
            if (userType.equals(sysUserType.getUserType()) && StringUtils.hasText(sysUserType.getIdentityId())) {
                value = Long.parseLong(sysUserType.getIdentityId());
            }
        }

        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();
        if (value != null) {
            log.info("userType is {}", value);
            dprRuleValueSysInternallyBo.setDprRuleValue(value.toString());
        } else {
            log.error("数据权限错误：账号没有{}信息", userType);
            dprRuleValueSysInternallyBo.setDprRuleValue("-1");
        }
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare(DprSysInternallyEnum.DPR_SYS_INTERNALLY_DYNAMIC.getValueDescription());
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());

        return dprRuleValueSysInternallyBo;
    }

    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_DYNAMIC;
    }
}
