package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.RoleAppApiDataPermissionRpcServiceUtil;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author : chen.niu
 * @description : 本人-员工
 * @date : 2023-12-22 13:23
 */
@Service
@Slf4j
public class DprSysInternallyEmployee implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();
        var employeeId = userInfo.getUser().getEmployeeId();
        if (employeeId != null){
            log.info("employeeId is {}", employeeId);
            dprRuleValueSysInternallyBo.setDprRuleValue(employeeId.toString());
        }else{
            log.error("数据权限错误：账号没有员工信息D");
            throw new BusinessException("数据权限错误：账号没有员工信息");
        }
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare( DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE.getValueDescription());
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());

//        dprRuleValueSysInternallyBo.setDprRuleValueDeclare("当前用户员工");
//        dprRuleValueSysInternallyBo.setDprRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
//        dprRuleValueSysInternallyBo.setDprRuleRelationName(DprRuleRelationEnum.DPR_RULE_RELATION_AND.getValueDescription());
//        dprRuleValueSysInternallyBo.setDprRuleField(null);
//       dprRuleValueSysInternallyBo.setDprRuleFieldDeclare("-");
//        dprRuleValueSysInternallyBo.setDprRuleCondition(DprRuleConditionEnum.Equal.name());
//        dprRuleValueSysInternallyBo.setDprRuleConditionName(DprRuleConditionEnum.Equal.getValueDescription());

        return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE;
    }
}
