package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description : 本人-员工业务员
 * @date : 2023-12-22 13:24
 */
@Service
@Slf4j
public class DprSysInternallyEmployeeSalesman implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();

        var userTypeList = userInfo.getUser().getUserTypeList();
        List<String> salesmanIdList = null;
        if (CollUtil.isNotEmpty(userTypeList)) {
            salesmanIdList = userTypeList.stream().filter(t -> UserType.SALESMAN.getValue().equals(t.getUserType()))
                    .map(SysUserType::getIdentityId)
                    .filter(StringUtils::hasText)
                    .collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(salesmanIdList)) {
            log.warn("未查询到员工的业务员ID：{}", userInfo.getUserId());
        }
        dprRuleValueSysInternallyBo.setDprRuleValue(normalizeValue(salesmanIdList));
        log.info("salesmanId:{}", dprRuleValueSysInternallyBo.getDprRuleValue());
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare( DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB.getValueDescription());
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());

        return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN;
    }
}
