package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:23
 */
@Service
@Slf4j
public class DprSysInternallyEmployeeSub implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();
        if (userInfo.getUser().getEmployeeId() != null){
            var underlingList = userInfo.getUser().getUnderlingList();
            List<Long> underlingIdList = null;
            if (CollUtil.isNotEmpty(underlingList)) {
                underlingIdList = underlingList.stream().map(SysUnderlingDTO::getEmployeeId).collect(Collectors.toList());
            }
            dprRuleValueSysInternallyBo.setDprRuleValue(normalizeValue(underlingIdList));
            log.info("underling：{}", dprRuleValueSysInternallyBo.getDprRuleValue());
        }else{
            log.error("数据权限错误：账号没有员工信息D");
            throw new BusinessException("数据权限错误：账号没有员工信息");
        }
        return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_SUB;
    }
}
