package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:24
 */
@Service
@Slf4j
public class DprSysInternallyOrg implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();

        // 所在组织
        dprRuleValueSysInternallyBo.setDprRuleValue(ObjectUtil.defaultIfNull(userInfo.getOrgId(), -1L).toString());
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare("当前用户组织：getOrgId");
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());

//        dprRuleValueSysInternallyBo.setDprRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
//        dprRuleValueSysInternallyBo.setDprRuleRelationName(DprRuleRelationEnum.DPR_RULE_RELATION_AND.getValueDescription());
//        dprRuleValueSysInternallyBo.setDprRuleField(FIELD_ORG);
//        dprRuleValueSysInternallyBo.setDprRuleFieldDeclare("数据归属组织id");
//        dprRuleValueSysInternallyBo.setDprRuleCondition(DprRuleConditionEnum.InList.name());
//        dprRuleValueSysInternallyBo.setDprRuleConditionName(DprRuleConditionEnum.InList.getValueDescription());
        return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_ORG;
    }
}
