package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:25
 */
@Service
@Slf4j
public class DprSysInternallyOu implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo rule = new DprRuleValueSysInternallyBo();

        // 所在公司
        if (isIdField(ruleDTO.getDprRuleField())) {
            rule.setDprRuleValue(ObjUtil.defaultIfNull(userInfo.getUser().getOuId(), -1L).toString());
        } else {
            rule.setDprRuleValue(CharSequenceUtil.blankToDefault(userInfo.getUser().getOuCode(), "unknown"));
        }
        rule.setDprRuleValueDeclare("当前用户公司ID");
        rule.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_TEXT.name());
        rule.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_TEXT.getValueDescription());

        return rule;
    }

    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_OU;
    }
}
