package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.DprSysInternallyStrategyUtil;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:24
 */
@Service
@Slf4j
public class DprSysInternallyUserSub implements IDprSysInternallyStrategy {
    private final OrgQueryService orgQueryService;
    private final EmployeeQueryService employeeQueryService;

    public DprSysInternallyUserSub(OrgQueryService orgQueryService, EmployeeQueryService employeeQueryService) {
        this.orgQueryService = orgQueryService;
        this.employeeQueryService = employeeQueryService;
    }

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();

        // 本人下级
        var subEmployeeUserIds = DprSysInternallyStrategyUtil.querySubEmployeeUserId(employeeQueryService,userInfo.getUserId());
        dprRuleValueSysInternallyBo.setDprRuleValue(this.normalizeValue(subEmployeeUserIds));
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare("当前用户ID：员工直接下级");
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());
//        dprRuleValueSysInternallyBo.setDprRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
//        dprRuleValueSysInternallyBo.setDprRuleRelationName(DprRuleRelationEnum.DPR_RULE_RELATION_AND.getValueDescription());
//        dprRuleValueSysInternallyBo.setDprRuleField(FIELD_CREATE_USER);
//        dprRuleValueSysInternallyBo.setDprRuleFieldDeclare("数据归属用户ID");
//        dprRuleValueSysInternallyBo.setDprRuleCondition(DprRuleConditionEnum.InList.name());
//        dprRuleValueSysInternallyBo.setDprRuleConditionName(DprRuleConditionEnum.InList.getValueDescription());

        return dprRuleValueSysInternallyBo;
    }

    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_USER_SUB;
    }
}
