package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectTreeNodeRespVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/19
 */
public interface BusinessObjectQueryService {

    /**
     * 业务对象树
     *
     * @param tree           是否返回树状
     * @param withApp        是否显示APP
     * @param withOperation  是否显示操作
     * @param withRef        是否显示关联的
     * @param permissionOnly 是否仅返回有权限的
     * @return 业务对象列表
     */
    ApiResult<List<BusinessObjectTreeNodeRespVO>> businessObjectTree(Boolean tree, Boolean withApp, Boolean withOperation,
                                                                     Boolean withRef, Boolean permissionOnly);

    /**
     * 获取所有的业务操作
     *
     * @return 业务操作列表
     */
    ApiResult<List<SysBusinessOperationDTO>> allOperationDTO();
}
