package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupEmpPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupEmpPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmpGroupSaveVO;

/**
 * 员工组管理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
public interface EmpGroupMngService {

    /**
     * 保存员工组
     *
     * @param saveVO 员工组信息
     * @return 员工组ID
     */
    ApiResult<Long> save(EmpGroupSaveVO saveVO);

    /**
     * 删除员工组信息
     *
     * @param id 员工组ID
     * @return 员工组ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 员工组ID
     * @return 切换结果
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 新增员工组的员工
     *
     * @param id         员工组ID
     * @param employeeId 员工ID
     * @return 员工组ID
     */
    ApiResult<Long> addEmployee(Long id, Long employeeId);

    /**
     * 删除员工组的指定员工
     *
     * @param id         员工组ID
     * @param employeeId 员工ID
     * @return 员工组ID
     */
    ApiResult<Long> deleteEmployee(Long id, Long employeeId);

    /**
     * 分页查询员工组
     *
     * @param queryVO 查询参数
     * @return 员工组列表
     */
    ApiResult<PagingVO<EmpGroupPageRespVO>> page(EmpGroupPageQueryVO queryVO);

    /**
     * 获取员工组详情
     *
     * @param id 员工组ID
     * @return 员工组详情
     */
    ApiResult<EmpGroupDetailRespVO> get(Long id);

    /**
     * 分页查询员工组的员工
     *
     * @param queryVO 查询参数
     * @return 员工组列表
     */
    ApiResult<PagingVO<EmpGroupEmpPageRespVO>> pageEmp(EmpGroupEmpPageQueryVO queryVO);
}
