package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupPageRespVO;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public interface EmpGroupQueryService {

    /**
     * 分页查询员工组
     *
     * @param queryVO
     * @return
     */
    ApiResult<PagingVO<EmpGroupPageRespVO>> pageQuery(EmpGroupPageQueryVO queryVO);

    /**
     * 查询员工组列表
     *
     * @param type
     * @param enabled
     * @return
     */
    ApiResult<List<EmpGroupListRespVO>> listQuery(String type, Boolean enabled);

    /**
     * 根据员工组编码获取组信息
     *
     * @param groupCode
     * @return
     */
    ApiResult<SysEmpGroupDTO> getByCode(@NotBlank String groupCode);

    /**
     * 获取详细信息
     *
     * @param groupId
     * @return
     */
    ApiResult<SysEmpGroupDTO> get(@NotNull Long groupId);

    /**
     * 获取员工组列表
     *
     * @return
     */
    ApiResult<List<SysEmpGroupDTO>> listAll();

    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCode 员工组编号
     * @return 用户ID
     */
    ApiResult<List<Long>> getUserIdsByGroupCode(@NotBlank String groupCode);


    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCodes 员工组编号
     * @return 员工组件与用户ID的map
     */
    ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(@NotEmpty Set<String> groupCodes);
}
