package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.menu.*;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuBoundSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuTreeSaveVO;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
public interface MenuMngService {

    /**
     * 新增菜单
     *
     * @param saveDTO
     * @return
     */
    ApiResult<Long> addMenu(SysMenuSaveDTO saveDTO);

    /**
     * 删除菜单
     *
     * @param menuCode 菜单编码
     * @return 菜单编码
     */
    ApiResult<String> removeMenu(String menuCode);

    /**
     * 保存菜单分组
     *
     * @param saveVO 保存菜单分组信息
     * @return 菜单分组ID
     */
    ApiResult<Long> saveCustomMenuGroup(CustomMenuGroupSaveVO saveVO);

    /**
     * 更新自定义菜单的启用状态
     *
     * @param id
     * @param enabled
     * @return
     */
    ApiResult<Long> updateCustomEnabled(Long id, Boolean enabled);

    /**
     * 清空所有自定义菜单
     *
     * @return 结果
     */
    ApiResult<Boolean> removeAllCustom();

    /**
     * 删除自定义菜单
     *
     * @param ids
     * @param cascade
     * @return
     */
    ApiResult<List<Long>> removeCustom(List<Long> ids, Boolean cascade);

    /**
     * 清空下级菜单
     *
     * @param id
     * @param withSelf
     * @return
     */
    ApiResult<Long> removeCustomChildren(Long id, Boolean withSelf);

    /**
     * 移动菜单
     *
     * @param id
     * @param newParentId
     * @param sortNo
     * @return
     */
    ApiResult<Long> moveCustom(Long id, Long newParentId, Integer sortNo);

    /**
     * 获取自定义菜单的编辑信息
     *
     * @param id
     * @return
     */
    ApiResult<CustomMenuEditRespVO> getCustomEdit(Long id);

    /**
     * 获取节点详细信息
     *
     * @param id
     * @return
     */
    ApiResult<CustomMenuNodeDetailRespVO> getCustomNodeDetail(Long id);

    /**
     * 获取分组列表
     *
     * @return 分组列表
     */
    ApiResult<List<IdCodeNameParam>> listGroup();

    /**
     * 绑定菜单
     *
     * @param saveVO
     * @return
     */
    ApiResult<String> saveBoundMenus(CustomMenuBoundSaveVO saveVO);

    /**
     * 获取分组关联的菜单
     *
     * @param groupCode
     * @return
     */
    ApiResult<List<CustomMenuBoundRespVO>> getBoundMenus(String groupCode);

    /**
     * 保存自定义菜单树
     *
     * @param saveVOList
     * @return
     */
    ApiResult<Boolean> saveTree(List<MenuTreeSaveVO> saveVOList);

    /**
     * 更新是否启用自定义菜单树
     *
     * @return 更新结果
     */
    ApiResult<Boolean> updateEnabledCustom();

    /**
     * 设置自定义名称
     *
     * @param id
     * @param customName
     * @return
     */
    ApiResult<Long> updateCustomName(Long id, String customName);

    /**
     * 获取自定义菜单树
     *
     * @param tree 是否显示树状
     * @return 树
     */
    ApiResult<List<CustomMenuTreeRespVO>> getCustomMenuTree(Boolean tree);

    /**
     * 获取默认菜单树
     *
     * @param tree 菜单树
     * @return 菜单树
     */
    ApiResult<List<MenuTreeRespVO>> getTreeDefault(Boolean tree);

    /**
     * 获取自定义菜单树
     *
     * @param tree 菜单树
     * @return 菜单树
     */
    ApiResult<List<MenuTreeCustomRespVO>> getTreeCustom(Boolean tree);

    /**
     * 是否启用自定义
     *
     * @return 启用状态
     */
    ApiResult<Boolean> getCustomEnabled();

    /**
     * 导出数据
     *
     * @return 唯一标识
     */
    ResponseEntity<StreamingResponseBody> export();

    /**
     * 导入数据
     *
     * @param file      数据文件
     * @param increment 是否增量
     * @return 导入结果
     */
    ApiResult<Boolean> importByFile(MultipartFile file, Boolean increment);

    /**
     * 根据平台菜单导入
     *
     * @return 导入结果
     */
    ApiResult<Boolean> importByPlatformMenu();
}
