package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticeEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.NoticeSaveVO;

import java.util.Set;

/**
 * 公告管理.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
public interface NoticeMngService {

    /**
     * 保存公告信息
     *
     * @param saveVO 公告信息
     * @return 公告ID
     */
    ApiResult<Long> save(NoticeSaveVO saveVO);

    /**
     * 保存公告信息
     *
     * @param saveVO 公告信息
     * @return 公告ID
     */
    ApiResult<Long> saveSys(NoticeSaveVO saveVO);


    /**
     * 删除公告
     *
     * @param ids  公告ID
     * @param real 是否真删除
     * @return 公告ID
     */
    ApiResult<Set<Long>> delete(Set<Long> ids, Boolean real);

    /**
     * 发布公告
     *
     * @param ids 公告ID
     * @return 公告ID
     */
    ApiResult<Set<Long>> execPublish(Set<Long> ids);

    /**
     * 撤回公告
     * <p>
     * 撤回已发布的公告
     *
     * @param ids 公告ID
     * @return 公告ID
     */
    ApiResult<Set<Long>> execRevoke(Set<Long> ids);

    /**
     * 获取编辑信息
     *
     * @param id 公告ID
     * @return 公告信息
     */
    ApiResult<NoticeEditRespVO> getEditVO(Long id);

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 公共列表
     */
    ApiResult<PagingVO<NoticePageRespVO>> pageMng(NoticePageMngQueryVO queryVO);

    /**
     * 分页查询管理系统公告
     *
     * @param queryVO 查询参数
     * @return 公共列表
     */
    ApiResult<PagingVO<NoticePageRespVO>> pageSysMng(NoticePageMngQueryVO queryVO);
}
