package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticeRespVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
public interface NoticeQueryService {

    /**
     * 分页查询已发布的公告
     *
     * @param queryVO 查询参数
     * @return 公告列表
     */
    ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublished(CommonPublishedNoticePageQueryVO queryVO);

    /**
     * 分页查询已发布的系统公告
     *
     * @param queryVO 查询参数
     * @return 公告列表
     */
    ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublishedSys(CommonPublishedNoticePageQueryVO queryVO);

    /**
     * 查看已发布的公告信息
     *
     * @param id 公告ID
     * @return 公告信息
     */
    ApiResult<CommonPublishedNoticeRespVO> viewPublishedNotice(Long id);
}
