package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.MenuApiSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionSaveVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 权限管理.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
public interface PermissionMngService {

    /**
     * 保存用户角色
     *
     * @param userId  用户ID
     * @param roleIds 角色ID
     * @return 用户ID
     */
    ApiResult<Long> saveUserRoles(@NotNull Long userId, List<Long> roleIds);

    /**
     * 批量保存用户角色
     *
     * @param saveDTOList 保存信息
     * @return 用户ID
     */
    ApiResult<List<Long>> saveUserRoles(@NotNull List<UserRoleSaveDTO> saveDTOList);

    /**
     * 保存角色下的用户
     *
     * @param roleId      角色ID
     * @param userIds     账号ID
     * @param incremental 是否为增量保存
     * @return 角色ID
     */
    ApiResult<Long> saveRoleUser(@NotNull Long roleId, List<Long> userIds, Boolean incremental);

    /**
     * 保存角色下的员工
     *
     * @param roleId      角色ID
     * @param userIds     账号ID
     * @param incremental 是否为增量保存
     * @return 角色ID
     */
    ApiResult<Long> saveRoleEmployee(@NotNull Long roleId, List<Long> userIds, Boolean incremental);

    /**
     * 删除角色下的指定用户
     *
     * @param roleId 角色ID
     * @param userId 账号ID
     * @return 角色ID
     */
    ApiResult<Long> removeRoleUser(@NotNull Long roleId, @NotNull Long userId);

    /**
     * 保存角色的权限菜单
     *
     * @param roleId     角色ID
     * @param saveVOList 权限信息（应用下的所有权限信息）
     * @return 角色ID
     */
    ApiResult<Long> savePermissionMenu(@NotNull Long roleId, List<RoleAppPermissionSaveVO> saveVOList);

    /**
     * 添加角色的权限菜单
     *
     * @param roleId 角色ID
     * @param saveVO 权限信息
     * @return 角色ID
     */
    ApiResult<Long> addPermissionMenu(@NotNull Long roleId, RoleAppPermissionSaveVO saveVO);

    /**
     * 删除角色的权限菜单
     *
     * @param roleId 角色ID
     * @param saveVO 权限信息
     * @return 角色ID
     */
    ApiResult<Long> removePermissionMenu(@NotNull Long roleId, RoleAppPermissionSaveVO saveVO);

    /**
     * 保存数据权限
     *
     * @param saveVO 保存信息
     * @return 角色ID
     */
    ApiResult<Long> saveApiDataPermission(SysDprSaveVO saveVO);

    /**
     * 保存数据权限
     *
     * @param saveVO 规则信息
     * @return 保存结果
     */
    ApiResult<Boolean> saveDataPermission(DataPermissionSaveVO saveVO);

    /**
     * 保存批量数据权限
     *
     * @param saveVO 保存信息
     * @return 保存结果
     */
    ApiResult<Boolean> saveApiDataPermission(SysDprBatchSaveVO saveVO);

    /**
     * 保存菜单挂载的API
     *
     * @param saveVO 菜单API
     * @return 结果
     */
    ApiResult<Boolean> saveMenuApi(MenuApiSaveVO saveVO);
}
